

<?php $__env->startSection('title', $thread->title); ?>

<?php $__env->startSection('content'); ?>
<div class="forum-container">
    <div class="forum-breadcrumbs">
        <a href="<?php echo e(route('forum.index')); ?>">Forums</a>
        <span class="separator">/</span>
        <a href="<?php echo e(route('forum.board', $board->slug)); ?>"><?php echo e($board->name); ?></a>
        <span class="separator">/</span>
        <span class="current"><?php echo e(\Illuminate\Support\Str::limit($thread->title, 30)); ?></span>
    </div>
    
    <div class="forum-thread-header">
        <h1><?php echo e($thread->title); ?></h1>
        <div class="meta">
            Started by  - <a href="<?php echo e(route('users.show', $thread->user->slug)); ?>"><?php echo e($thread->user->name); ?></a>
            <span class="dot"></span>
            <?php echo e($thread->created_at->format('M d, Y')); ?>

            <span class="dot"></span>
            <?php echo e($thread->view_count); ?> views
            
            <?php if($thread->is_locked): ?>
                <span class="dot"></span>
                <span class="locked">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                        <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                    </svg>
                    Locked
                </span>
            <?php endif; ?>
            
            <?php if($thread->is_pinned): ?>
                <span class="dot"></span>
                <span class="pinned">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M12 2L12 22"></path>
                        <path d="M18 8L12 2 6 8"></path>
                    </svg>
                    Pinned
                </span>
            <?php endif; ?>
        </div>
        
        <?php if(auth()->guard()->check()): ?>
            <?php if(Auth::user()->can('moderate forums') || Auth::id() === $thread->user_id): ?>
                <div class="thread-moderation">
                    <?php if(Auth::user()->can('moderate forums')): ?>
                        <div class="dropdown">
                            <button class="btn moderation-btn">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                    <circle cx="12" cy="12" r="1"></circle>
                                    <circle cx="19" cy="12" r="1"></circle>
                                    <circle cx="5" cy="12" r="1"></circle>
                                </svg>
                                Moderate
                            </button>
                            <div class="dropdown-content">
                                <a href="<?php echo e(route('forum.edit-thread', [$board->slug, $thread->slug])); ?>" class="edit-link">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                                        <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                    </svg>
                                    Edit Thread
                                </a>
                                
                                <form action="<?php echo e(route('forum.toggle-lock-thread', [$board->slug, $thread->slug])); ?>" method="POST" class="inline-form">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="lock-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <rect x="3" y="11" width="18" height="11" rx="2" ry="2"></rect>
                                            <path d="M7 11V7a5 5 0 0 1 10 0v4"></path>
                                        </svg>
                                        <?php echo e($thread->is_locked ? 'Unlock Thread' : 'Lock Thread'); ?>

                                    </button>
                                </form>
                                
                                <form action="<?php echo e(route('forum.toggle-pin-thread', [$board->slug, $thread->slug])); ?>" method="POST" class="inline-form">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" class="pin-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M12 2L12 22"></path>
                                            <path d="M18 8L12 2 6 8"></path>
                                        </svg>
                                        <?php echo e($thread->is_pinned ? 'Unpin Thread' : 'Pin Thread'); ?>

                                    </button>
                                </form>
                                
                                <form action="<?php echo e(route('forum.delete-thread', [$board->slug, $thread->slug])); ?>" method="POST" class="inline-form" onsubmit="return confirm('Are you sure you want to delete this thread? This action cannot be undone.');">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="delete-link">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <polyline points="3 6 5 6 21 6"></polyline>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                            <line x1="10" y1="11" x2="10" y2="17"></line>
                                            <line x1="14" y1="11" x2="14" y2="17"></line>
                                        </svg>
                                        Delete Thread
                                    </button>
                                </form>
                            </div>
                        </div>
                    <?php elseif(Auth::id() === $thread->user_id): ?>
                        <a href="<?php echo e(route('forum.edit-thread', [$board->slug, $thread->slug])); ?>" class="btn edit-btn">
                            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                                <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                            </svg>
                            Edit
                        </a>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
    
    <!-- Original Post -->
    <div class="forum-thread-content">
        <div class="author">
            <div class="avatar">
                <img src="<?php echo e($thread->user->avatar); ?>" alt="<?php echo e($thread->user->name); ?>">
            </div>
            <div class="info">
                <div class="name"><a href="<?php echo e(route('users.show', $thread->user->slug)); ?>"><?php echo e($thread->user->name); ?></a></div>
                <?php if($thread->user->isAdmin ?? false): ?>
                    <div class="role">Admin</div>
                <?php elseif($thread->user->isModerator ?? false): ?>
                    <div class="role">Moderator</div>
                <?php endif; ?>
                <div class="joined">Joined <?php echo e($thread->user->created_at->format('M Y')); ?></div>
            </div>
        </div>
        
        <div class="content bbcode-content">
            <?php echo \App\Helpers\HtmlSanitizer::sanitize((new \Golonka\BBCode\BBCodeParser)->parse($thread->content)); ?>
        </div>
        
        <div class="reactions">
            <?php $__currentLoopData = App\Models\ForumReaction::getTypes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $emoji): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div 
                    class="reaction <?php echo e(Auth::check() && $thread->reactions()->where('user_id', Auth::id())->where('type', $type)->exists() ? 'active' : ''); ?>"
                    data-thread-id="<?php echo e($thread->id); ?>"
                    data-type="<?php echo e($type); ?>"
                    onclick="toggleThreadReaction(this)"
                >
                    <span class="emoji"><?php echo e($emoji); ?></span>
                    <span class="count"><?php echo e($thread->reactions()->where('type', $type)->count()); ?></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    
    <!-- Replies -->
    <div class="forum-thread-replies">
        <h2>Replies</h2>
        
        <?php $__empty_1 = true; $__currentLoopData = $posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="post" id="post-<?php echo e($post->id); ?>">
                <div class="author">
                    <div class="avatar">
                        <img src="<?php echo e($post->user->avatar); ?>" alt="<?php echo e($post->user->name); ?>">
                    </div>
                    <div class="info">
                        <div class="name-time">
                            <div class="name"><a href="<?php echo e(route('users.show', $post->user->slug)); ?>"><?php echo e($post->user->name); ?></a></div>
                            <div class="time">
                                <?php echo e($post->created_at->format('M d, Y g:i A')); ?>

                                <?php if($post->is_edited): ?>
                                    <span class="edited-tag">(edited <?php echo e($post->edited_at->format('M d, Y')); ?>)</span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if($post->user->isAdmin ?? false): ?>
                            <div class="role">Admin</div>
                        <?php elseif($post->user->isModerator ?? false): ?>
                            <div class="role">Moderator</div>
                        <?php endif; ?>
                        
                        <?php if(auth()->guard()->check()): ?>
                            <?php if(Auth::user()->can('moderate forums') || Auth::id() === $post->user_id): ?>
                                <div class="post-actions">
                                    <a href="<?php echo e(route('forum.edit-post', [$board->slug, $thread->slug, $post->id])); ?>" class="post-action edit">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                            <path d="M11 4H4a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2-2v-7"></path>
                                            <path d="M18.5 2.5a2.121 2.121 0 0 1 3 3L12 15l-4 1 1-4 9.5-9.5z"></path>
                                        </svg>
                                        Edit
                                    </a>
                                    
                                    <?php if(Auth::user()->can('moderate forums')): ?>
                                        <form action="<?php echo e(route('forum.delete-post', [$board->slug, $thread->slug, $post->id])); ?>" method="POST" class="inline-form" onsubmit="return confirm('Are you sure you want to delete this post? This action cannot be undone.');">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="post-action delete">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                    <polyline points="3 6 5 6 21 6"></polyline>
                                                    <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2"></path>
                                                    <line x1="10" y1="11" x2="10" y2="17"></line>
                                                    <line x1="14" y1="11" x2="14" y2="17"></line>
                                                </svg>
                                                Delete
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="content bbcode-content">
                    <?php echo \App\Helpers\HtmlSanitizer::sanitize((new \Golonka\BBCode\BBCodeParser)->parse($post->content)); ?>
                </div>
                
                <div class="reactions">
                    <?php $__currentLoopData = App\Models\ForumReaction::getTypes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $emoji): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div 
                            class="reaction <?php echo e(Auth::check() && $post->hasReactionFromUser(Auth::id(), $type) ? 'active' : ''); ?>" 
                            data-post-id="<?php echo e($post->id); ?>"
                            data-type="<?php echo e($type); ?>"
                            onclick="toggleReaction(this)"
                        >
                            <span class="emoji"><?php echo e($emoji); ?></span>
                            <span class="count"><?php echo e($post->getReactionCount($type)); ?></span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="no-replies">No replies yet. Be the first to reply!</div>
        <?php endif; ?>
        
        <div class="mt-4">
            <?php echo e($posts->links()); ?>

        </div>
    </div>
    
    <!-- Reply Form -->
    <?php if(!$thread->is_locked): ?>
        <?php if(auth()->guard()->check()): ?>
            <div class="forum-thread-reply-form">
                <h3>Post a Reply</h3>
                
                <form action="<?php echo e(route('forum.store-post', [$board->slug, $thread->slug])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="form-group">
                        <?php if (isset($component)) { $__componentOriginal8675d3916afa2a668da613c7f0e53afc = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal8675d3916afa2a668da613c7f0e53afc = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.bbcode-editor','data' => ['name' => 'content','placeholder' => 'Write your reply here...','content' => old('content'),'height' => '200px']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('bbcode-editor'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'content','placeholder' => 'Write your reply here...','content' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('content')),'height' => '200px']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal8675d3916afa2a668da613c7f0e53afc)): ?>
<?php $attributes = $__attributesOriginal8675d3916afa2a668da613c7f0e53afc; ?>
<?php unset($__attributesOriginal8675d3916afa2a668da613c7f0e53afc); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal8675d3916afa2a668da613c7f0e53afc)): ?>
<?php $component = $__componentOriginal8675d3916afa2a668da613c7f0e53afc; ?>
<?php unset($__componentOriginal8675d3916afa2a668da613c7f0e53afc); ?>
<?php endif; ?>
                        <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="error-message"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit">Post Reply</button>
                    </div>
                </form>
            </div>
        <?php else: ?>
            <div class="forum-login-prompt">
                <p>You need to <a href="<?php echo e(route('login.steam')); ?>">log in</a> to reply to this thread.</p>
            </div>
        <?php endif; ?>
    <?php else: ?>
        <div class="forum-thread-locked-message">
            <p>This thread is locked. No new replies can be posted.</p>
        </div>
    <?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    function toggleReaction(element) {
        if (!<?php echo e(Auth::check() ? 'true' : 'false'); ?>) {
            window.location.href = "<?php echo e(route('login.steam')); ?>";
            return;
        }
        
        const postId = element.getAttribute('data-post-id');
        const type = element.getAttribute('data-type');
        
        fetch('<?php echo e(route('forum.toggle-reaction')); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                post_id: postId,
                type: type
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const countElement = element.querySelector('.count');
                countElement.textContent = data.count;
                
                if (data.action === 'added') {
                    element.classList.add('active');
                } else {
                    element.classList.remove('active');
                }
            }
        })
        .catch(error => {
            console.error('Error toggling reaction:', error);
        });
    }
    
    function toggleThreadReaction(element) {
        if (!<?php echo e(Auth::check() ? 'true' : 'false'); ?>) {
            window.location.href = "<?php echo e(route('login.steam')); ?>";
            return;
        }
        
        const threadId = element.getAttribute('data-thread-id');
        const type = element.getAttribute('data-type');
        
        fetch('<?php echo e(route('forum.toggle-thread-reaction')); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
            },
            body: JSON.stringify({
                thread_id: threadId,
                type: type
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const countElement = element.querySelector('.count');
                countElement.textContent = data.count;
                
                if (data.action === 'added') {
                    element.classList.add('active');
                } else {
                    element.classList.remove('active');
                }
            }
        })
        .catch(error => {
            console.error('Error toggling thread reaction:', error);
        });
    }
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/forum/thread.blade.php ENDPATH**/ ?>